---
name: cognitor-cli-agent-integration
description: Integrates downloaded Cognitor CLI binaries into agent environments (Cursor, Claude Code). Use when setting up Cognitor CLI in external projects, authenticating against production, and executing reproducible API workflows via CLI commands.
---

# Cognitor CLI Agent Integration

## Purpose

Use this skill in end-user projects where the CLI is downloaded from the Cognitor website and used by an agent to operate the Cognitor API.

Goals:
- install `cognitor` reliably on macOS/Windows,
- configure production defaults,
- run API operations with reproducible CLI commands,
- avoid project-specific repository assumptions.

## When To Apply

Apply this skill when the user asks to:
- integrate Cognitor CLI into a non-Cognitor project,
- use Cognitor CLI with Cursor/Claude Code tasks,
- run endpoint operations via generated CLI groups or raw CLI requests,
- diagnose login or endpoint-access issues in production.

## Prerequisites

1. CLI binary is downloaded from `https://www.cognitor.com/cli`.
2. Agent can run terminal commands in the user project.
3. Credentials are provided by user (never invent credentials).

## Standard Workflow

Copy this checklist and execute in order:

```text
CLI Agent Task Checklist
- [ ] Verify CLI binary and version
- [ ] Configure profile (prod default)
- [ ] Authenticate
- [ ] Run requested endpoint operations
- [ ] Validate output format and status
- [ ] Run smoke test if task is broad
- [ ] Report concise command/results summary
```

### 1) Install and verify CLI

```bash
# macOS (Apple Silicon example)
curl -L -o cognitor https://www.cognitor.com/downloads/cli/cognitor_0.1.0_darwin_arm64
chmod +x cognitor
sudo mv cognitor /usr/local/bin/cognitor

# verify
cognitor version
```

Optional integrity check:

```bash
curl -L -o checksums.txt https://www.cognitor.com/downloads/cli/checksums.txt
shasum -a 256 /usr/local/bin/cognitor
```

### 2) Configure Production Profile (Default)

Always default to production unless user explicitly asks for another environment.

```bash
cognitor config set --profile prod --base-url https://backend.cognitor.dev
cognitor config use prod
cognitor doctor --profile prod
```

### 3) Authenticate

```bash
cognitor auth login --profile prod --username "<email>" --password "<password>"
cognitor auth whoami --profile prod --output json
```

If login fails:
1. check base URL,
2. verify endpoint path with `cognitor api endpoints --filter auth`,
3. retry only after user confirms credentials.

### 4) Endpoint Operations

Prefer generated endpoint groups first:

```bash
cognitor api groups
cognitor api authentication get-auth-currentuser --profile prod --output json
cognitor api admin-monitoring get-admin-monitoring-system-health --profile prod --output json
```

Use raw request mode for any operation:

```bash
cognitor api request --profile prod --method GET --path /auth/currentuser --output json
```

Path parameters:

```bash
cognitor api search get-search-sites-by-site-identifier \
  --profile prod \
  --path-param site_identifier=nvidia-investor-portal \
  --query q=ai \
  --output json
```

## Smoke Test Modes (Project-agnostic)

### Quick Read-Only Smoke

```bash
cognitor auth whoami --profile prod --output json
cognitor sites list --profile prod --output json
cognitor posts list --profile prod --site nvidia-investor-portal --page 1 --size 5 --output json
```

For full write E2E in customer projects, prefer explicit create/update/delete commands with clear cleanup steps.

## Output Style For Agent Reports

Always include:
1. commands run,
2. pass/fail per operation,
3. cleanup status for write tests,
4. blockers requiring user input.

Keep results concise and factual.

## Safety Rules

- Never expose credentials in logs or summaries.
- Never assume non-production unless user explicitly requests it.
- Prefer `--output json` for machine-verifiable checks.
- For write tests, always ensure cleanup (delete created posts/media).

## Additional Resources

- Command examples and templates: [examples.md](examples.md)
- Full API usage reference: [reference.md](reference.md)
