# Cognitor CLI Skill Examples

## 1) Install binary and verify

```bash
curl -L -o cognitor https://www.cognitor.com/downloads/cli/cognitor_0.1.0_darwin_arm64
chmod +x cognitor
sudo mv cognitor /usr/local/bin/cognitor
cognitor version
```

## 2) Production auth and health checks

```bash
cognitor config set --profile prod --base-url https://backend.cognitor.dev
cognitor auth login --profile prod --username "<email>" --password "<password>"
cognitor api authentication get-auth-currentuser --profile prod --output json
cognitor api admin-monitoring get-admin-monitoring-system-health --profile prod --output json
```

## 3) Generic endpoint call with form body

```bash
cognitor api request \
  --profile prod \
  --method POST \
  --path /auth/token \
  --form grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer \
  --form assertion="<jwt>" \
  --auth=false \
  --output json
```

## 4) Multipart upload through generic request

```bash
cognitor api request \
  --profile prod \
  --method POST \
  --path /nvidia-investor-portal/media/ \
  --file file=./my-file.pdf \
  --field name=my-file-upload \
  --field title="My File Upload" \
  --output json
```

## 5) Endpoint discovery in agent workflows

```bash
cognitor api groups
cognitor api endpoints --filter media
```

## 6) Quick read-only smoke in customer project

```bash
cognitor auth whoami --profile prod --output json
cognitor sites list --profile prod --output json
cognitor posts list --profile prod --site nvidia-investor-portal --page 1 --size 5 --output json
```
