# Cognitor CLI Reference (Agent Integration)

This reference is for agents integrating the downloaded `cognitor` binary into external projects.

## 1) Full API Discovery

Use these commands as the canonical source of truth:

```bash
# All endpoint groups
cognitor api groups

# All endpoints from OpenAPI
cognitor api endpoints

# Filter endpoints
cognitor api endpoints --filter media

# Group-specific operations
cognitor api <group> --help
```

## 2) Current Endpoint Groups (Production OpenAPI)

The generated CLI currently exposes these groups:

- `admin-content-types`
- `admin-fraud-detection`
- `admin-monitoring`
- `agents`
- `authentication`
- `cache-management`
- `contact`
- `content-elements-admin`
- `content-types`
- `global-cost-settings`
- `health`
- `media`
- `media-folders`
- `pages-admin`
- `payments`
- `payments-webhooks`
- `posts`
- `public-content`
- `root`
- `search`
- `seo`
- `service-accounts`
- `site-statistics`
- `sites`
- `subscription`
- `system-prompts`
- `tenant-management`
- `transactions`
- `transferprompts`
- `translations`
- `user-site-associations`
- `users`
- `website-generation`

Use this pattern to inspect operations in one group:

```bash
cognitor api media --help
cognitor api authentication --help
cognitor api tenant-management --help
```

## 3) Request Modes

### A) Generated operation command (preferred)

```bash
cognitor api authentication get-auth-currentuser --profile prod --output json
```

### B) Raw generic request (fallback for any endpoint)

```bash
cognitor api request \
  --profile prod \
  --method GET \
  --path /auth/currentuser \
  --output json
```

## 4) Common Parameters and Flags

Global flags (all commands):

- `--profile` profile name (`prod` recommended)
- `--output` `table|json|yaml`
- `--timeout` request timeout
- `--verbose` include extra runtime output

Operation-level flags:

- `--path-param key=value` for path placeholders like `{site_identifier}`
- `--query key=value` for query parameters
- `--header key=value` for custom headers
- `--auth=true|false` attach bearer token or not

Body modes:

- `--json '{...}'` inline JSON
- `--json-file payload.json` file JSON
- `--form key=value` urlencoded forms
- `--field key=value` + `--file field=/path` multipart

## 5) Path Parameter Examples

```bash
# /search/sites/{site_identifier}
cognitor api search get-search-sites-by-site-identifier \
  --profile prod \
  --path-param site_identifier=nvidia-investor-portal \
  --query q=ai \
  --output json

# /admin/tenants/{tenant_id}
cognitor api tenant-management get-admin-tenants-by-tenant-id \
  --profile prod \
  --path-param tenant_id=51 \
  --output json
```

## 6) Auth Baseline

```bash
cognitor config set --profile prod --base-url https://backend.cognitor.dev
cognitor config use prod
cognitor auth login --profile prod --username "<email>" --password "<password>"
cognitor auth whoami --profile prod --output json
```

If an endpoint is public, add `--auth=false`.

## 7) Reliability Pattern For Agents

For each task:

1. `cognitor auth whoami --profile prod --output json`
2. Run target operation with `--output json`
3. Validate HTTP/application result fields
4. For write operations, perform cleanup commands

This keeps automation deterministic and auditable.
